// elementx.js - White Label Ready

(function () {
    // ✅ CONFIGURAÇÃO CENTRAL - EDITÁVEL
    const whiteLabelConfig = {
        brandName: "ZapHub CRM", // 🔧 PERSONALIZAR
        version: "3.5.5",

        logo: {
            old: "https://zapyhub.com/assets/images/logo/logo.png",
            new: "https://zapyhub.com/assets/images/logo/logo.png" // 🔧 PERSONALIZAR
        },

        whatsapp: {
            oldNumber: "917426038448",
            newNumber: "557991313511" // 🔧 PERSONALIZAR
        },

        customDomain: "https://zapyhub.com/buy", // 🔧 PERSONALIZAR

        links: {
            tutorials: "https://zapyhub.com/tutorials", // 🔧 PERSONALIZAR
            requestFeature: "https://zapyhub.com/request-feature", // 🔧 PERSONALIZAR
            privacyPolicy: "https://zapyhub.com/privacy-policy" // 🔧 PERSONALIZAR
        },

        priceSymbolOld: "USD",
        priceSymbolNew: "R$",

        supportMessageEN: "Hello there! I am facing an issue with Extension. I need your assistance.",
        supportMessagePT: "Quero Saber Mais sobre a Extensão"
    };

    // ✅ TEXTOS QUE SERÃO TRADUZIDOS/SUBSTITUÍDOS
    const TRANSLATIONS = {
        "Botzo CRM": whiteLabelConfig.brandName,
        "Botzo": whiteLabelConfig.brandName,
        "Extensão CRM": `${whiteLabelConfig.brandName} ${whiteLabelConfig.version}`,
        "Welcome to Botzo CRM": `Bem-vindo ao ${whiteLabelConfig.brandName}`,
        "Loading...": "Carregando...",
        "Monthly Plan": "Plano Mensal",
        "Yearly Plan": "Plano Anual",
        "WhatsApp CRM": whiteLabelConfig.brandName,
        "1 Days Trial": "1 Dia de Teste",
        "Message automation": "Automação de mensagens",
        "Unlimited messaging": "Mensagens ilimitadas",
        "Contact tagging and segmentation functionality": "Etiquetagem e segmentação de contatos",
        "Unlimited contact management": "Gerenciamento ilimitado de contatos",
        "Full conversation history": "Histórico completo de conversas",
        "Detailed reports and analysis": "Relatórios e análises detalhados",
        "Advanced integration with WhatsApp": "Integração avançada com WhatsApp",
        "Priority support via email and live chat": "Suporte prioritário por e-mail e chat ao vivo",
        "All features of the free plan": "Todos os recursos do plano gratuito",
        "R$ Get offer": "R$ Obter Oferta",
        "Get offer": "Obter Oferta",
        "Obtén oferta": "Obter Oferta",
        "buy": "COMPRAR",
        "USD": whiteLabelConfig.priceSymbolNew,
        "License Details": "Detalhes da Licença",
        "Here you will find detailed information about your license and options to uninstall it if necessary.": "Aqui você encontrará informações detalhadas sobre sua licença e opções para desinstalá-la, se necessário.",
        "User:": "Usuário:",
        "Phone:": "Telefone:",
        "License:": "Licença:",
        "Plan:": "Plano:",
        "Next Payment:": "Próximo Pagamento:",
        "Uninstall License": "Desinstalar Licença",
        "Close": "Fechar",
        "You must have Valid & Active License Key": "Você precisa de uma Chave de Licença Válida e Ativa",
        "Enter your license key & click on Activate to Activate your License Key.": "Insira sua chave de licença e clique em Ativar para ativar sua chave de licença.",
        "Activate Now": "Ativar Agora",
        "You must enter a key": "Você deve inserir uma chave",
        "Please enter your license key in the field below to activate advanced features.": "Insira sua chave de licença no campo abaixo para ativar recursos avançados.",
        "undefined": "indefinido",
        "Sort": "Organizar",
        "Validate": "VALIDAR",
        "Done": "Concluído",
        "To Do": "A Fazer",
        "Processing": "Processando",
        "Cancel": "Cancelar",
        "OK": "OK",
        "Column": "Coluna",
        "Digite o Nome da Coluna:": "Digite o Nome da Coluna:",
        "Adicionar": "Adicionar",
        "Excluir": "Excluir",
        "Inbox": "Caixa de Entrada",
        "Perto": "Fechar",
        "Cancelararararar": "Cancelar",
        "Cancelararar": "Cancelar",
        "Cancelarararar": "Cancelar",
        "Cancelarar": "Cancelar",
        "Recent 50 Chats": "50 Chats Recentes"
    };

    function replaceTexts() {
        document.querySelectorAll("*:not(script):not(style)").forEach((element) => {
            element.childNodes.forEach((node) => {
                if (node.nodeType === Node.TEXT_NODE) {
                    Object.entries(TRANSLATIONS).forEach(([key, value]) => {
                        if (node.nodeValue.includes(key)) {
                            node.nodeValue = node.nodeValue.replace(new RegExp(key, "g"), value);
                        }
                    });
                }
            });
        });
    }

    function replaceLogo() {
        document.querySelectorAll(`img[src="${whiteLabelConfig.logo.old}"]`).forEach((img) => {
            img.src = whiteLabelConfig.logo.new;
            console.log(`Logo trocado: ${whiteLabelConfig.logo.old} -> ${whiteLabelConfig.logo.new}`);
        });
    }

    function replaceLinks() {
        const TARGET_LINKS = [
            "https://web.whatsapp.com/[object%20Object]",
            "https://wa.me/#?text=WA%20CRM%201%20Days%20Trail",
            "https://web.whatsapp.com/#"
        ];

        document.querySelectorAll("a").forEach((link) => {
            TARGET_LINKS.forEach((target) => {
                if (link.href.includes(target)) {
                    link.href = whiteLabelConfig.customDomain;
                    console.log(`Link substituído: ${target} -> ${whiteLabelConfig.customDomain}`);
                }
            });

            if (link.href.includes("lotsofcode.in")) {
                link.href = link.href.replace(/lotsofcode\.in/g, whiteLabelConfig.customDomain);
            }
        });
    }

    function replaceSpecialLinks() {
        const { tutorials, requestFeature, privacyPolicy } = whiteLabelConfig.links;

        document.querySelectorAll("a").forEach((link) => {
            if (link.href.includes("/tutorials")) link.href = tutorials;
            if (link.href.includes("/request-feature")) link.href = requestFeature;
            if (link.href.includes("/privacy-policy")) link.href = privacyPolicy;
        });
    }

    function replacePrices() {
        document.querySelectorAll("div, span, p").forEach((el) => {
            if (el.innerText.includes(whiteLabelConfig.priceSymbolOld)) {
                el.innerText = el.innerText.replace(whiteLabelConfig.priceSymbolOld, whiteLabelConfig.priceSymbolNew);
            }
        });
    }

    function ensureWhatsAppLinkAlwaysUpdated() {
        const { oldNumber, newNumber } = whiteLabelConfig.whatsapp;

        document.querySelectorAll("a[href*='wa.me']").forEach((link) => {
            if (link.href.includes(oldNumber)) {
                link.href = link.href.replace(oldNumber, newNumber);
            }

            link.addEventListener("click", () => {
                if (link.href.includes(oldNumber)) {
                    link.href = link.href.replace(oldNumber, newNumber);
                }
            });
        });
    }

    function forceWhatsAppReplacementRepeatedly() {
        let attempts = 0;
        const interval = setInterval(() => {
            ensureWhatsAppLinkAlwaysUpdated();
            if (++attempts >= 10) clearInterval(interval);
        }, 1000);
    }

    function replaceMessages() {
        const { supportMessageEN, supportMessagePT } = whiteLabelConfig;

        document.querySelectorAll("*:not(script):not(style)").forEach((el) => {
            el.childNodes.forEach((node) => {
                if (node.nodeType === Node.TEXT_NODE && node.nodeValue.includes(supportMessageEN)) {
                    node.nodeValue = node.nodeValue.replace(new RegExp(supportMessageEN, "g"), supportMessagePT);
                }
            });
        });
    }

    function fixGroupMessageSending() {
        const originalSendTextMsgToChat = window.Store?.SendTextMsgToChat;

        if (originalSendTextMsgToChat) {
            window.Store.SendTextMsgToChat = async function (chat, ...args) {
                try {
                    if (chat.isGroup && !chat.id.server.includes("g.us")) {
                        chat.id.server = "g.us";
                    }
                    return originalSendTextMsgToChat.apply(this, [chat, ...args]);
                } catch (error) {
                    console.error("Erro ao corrigir envio para grupos:", error);
                }
            };
        }
    }

    function monitorDOMChanges() {
        const observer = new MutationObserver(() => {
            replaceTexts();
            replaceLogo();
            replaceLinks();
            replaceSpecialLinks();
            replacePrices();
            ensureWhatsAppLinkAlwaysUpdated();
            replaceMessages();
        });

        observer.observe(document.body, { childList: true, subtree: true });
    }

    function initialize() {
        const main = () => {
            replaceTexts();
            replaceLogo();
            replaceLinks();
            replaceSpecialLinks();
            replacePrices();
            ensureWhatsAppLinkAlwaysUpdated();
            forceWhatsAppReplacementRepeatedly();
            replaceMessages();
            fixGroupMessageSending();
            monitorDOMChanges();
        };

        if (document.readyState === "loading") {
            document.addEventListener("DOMContentLoaded", main);
        } else {
            main();
        }
    }

    initialize();
})();
